module RPG
  class Tileset
    def initialize
      @id = 0
      @name = ""
      @tileset_name = ""
      @autotile_names = [""]*7
      @panorama_name = ""
      @panorama_hue = 0
      @fog_name = ""
      @fog_hue = 0
      @fog_opacity = 64
      @fog_blend_type = 0
      @fog_zoom = 200
      @fog_sx = 0
      @fog_sy = 0
      @battleback_name = ""
      @passages = Table.new(384)
      @priorities = Table.new(384)
      @priorities[0] = 5
      @terrain_tags = Table.new(384)
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :tileset_name
    attr_accessor :autotile_names
    attr_accessor :panorama_name
    attr_accessor :panorama_hue
    attr_accessor :fog_name
    attr_accessor :fog_hue
    attr_accessor :fog_opacity
    attr_accessor :fog_blend_type
    attr_accessor :fog_zoom
    attr_accessor :fog_sx
    attr_accessor :fog_sy
    attr_accessor :battleback_name
    attr_accessor :passages
    attr_accessor :priorities
    attr_accessor :terrain_tags


    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = self.cast(My_RPG::My_Tileset)
      return my
    end


    def comparer(other)

      
      list_self = [
        @id,
        @name,
        @tileset_name,
        @autotile_names,
        @panorama_name,
        @panorama_hue,
        @fog_name,
        @fog_hue,
        @fog_opacity,
        @fog_blend_type,
        @fog_zoom,
        @fog_sx,
        @fog_sy,
        @battleback_name
      ]

      list_other = [
        other.id,
        other.name,
        other.tileset_name,
        other.autotile_names,
        other.panorama_name,
        other.panorama_hue,
        other.fog_name,
        other.fog_hue,
        other.fog_opacity,
        other.fog_blend_type,
        other.fog_zoom,
        other.fog_sx,
        other.fog_sy,
        other.battleback_name
      ]

      
      if list_self != list_other
        raise(DMKW_DMK_Diff.new("Tileset.parameters"))
      end

      raise(DMKW_DMK_Diff.new("tileset.passages")) if @passages.comparer(other.passages) == false
      raise(DMKW_DMK_Diff.new("tileset.priorities")) if @priorities.comparer(other.priorities) == false
      raise(DMKW_DMK_Diff.new("tileset.terrain_tags")) if @terrain_tags.comparer(other.terrain_tags) == false


      return true
    end


  end
end
